;
;								EJEMPLO 10
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;La interrupcin externa RBO/INT y el modo sleep.
;
;Se trata de comprobar la interrupcin externa que se aplica a travs del pin RBO/INT
;El programa principal est en un ciclo cerrado en modo SLEEP (standby de bajo consumo). Cada vez que
;se detecta un flanco descendente en RB0 se provoca una interrupcin cuyo tratamiento hace iluminar 
;las salidas RB7-RB1 durante 1 seg.
	
		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdig y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

		__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

Contador		equ	0x020			;Variable para la temporizacin
                    
				org	0x00			;Vector de RESET
				goto	Inicio
				org	0x04			;Vector de interrupcin
				goto	Interrupcion
				org	0x05

Interrupcion   	bcf		INTCON,INTF	;Repone flag de la interrupcin externa
				movlw	b'11111110'
				movwf	PORTB		;Activa las salidas
				movlw	.100
				movwf	Contador	;Inicia contador de temporizaciones de 10 ms con 100 (1")
Seguir			bcf		INTCON,T0IF	;Reponer flag del TMR0
				movlw 	~.39
           		movwf 	TMR0      	;Repone el TMR0 con 39 para temporizar 10 mS
Delay_10ms		btfss	INTCON,T0IF	;Han transcurrido 10 mS ??
				goto	Delay_10ms	;No, esperar
				decfsz 	Contador,F	;Decrementa el contador. Se ha repetido 100 veces la temporizacin ?
				goto	Seguir		;No
				clrf	PORTB		;Si, ha pasado 1", se desconectar las salidas
				retfie				;Retorno de interrupcin
		
Inicio	       	clrf 	PORTB		;Borra los latch de salida
				bsf		STATUS,RP0	;Selecciona banco 1
				movlw	b'00000001'
				movwf	TRISB		;RB7-RB1 salidas, RB0/INT entrada
				movlw	b'00000111'
				movwf	OPTION_REG	;Preescaler de 256 para el TMR0, 
									;RB0/INT sensible a flanco descendente
				bcf		STATUS,RP0	;Selecciona banco 0			                                                                         
				movlw	b'10010000'
				movwf	INTCON		;Activa la interrupcin externa RB0/INT

;Este es el cuerpo del programa principal. Se mantiene en estado SLEEP hasta que 
;se produce interrupcin

Loop			sleep
				nop
				goto 	Loop

				end					;Fin del programa fuente

